import React, { useEffect, useState } from "react";
import { useSelector } from "react-redux";
import { Tokens } from "../../constants";
import { Dropdown, DropdownButton } from "react-bootstrap-v5";

const LanguageLayout = () => {
    const [selectedLanguage, setSelectedLanguage] = useState({});
    const { languages } = useSelector((state) => state);
    const updatedLanguage = localStorage.getItem(Tokens.UPDATED_LANGUAGE) || 'en';

    useEffect(() => {
        if (updatedLanguage) {
            const matchedLanguage = languages.find(
                (language) => language?.attributes?.iso_code === updatedLanguage
            );
            setSelectedLanguage(matchedLanguage);
        }
    }, [languages]);

    const handleLanguage = (language) => {
        setSelectedLanguage(language);
        localStorage.setItem(
            "updated_language",
            language?.attributes?.iso_code
        );
        window.location.reload();
    };

    // SVG Component
    const LanguageIcon = () => (
        <svg
            className="svg-inline--fa fa-language mx-1"
            aria-hidden="true"
            focusable="false"
            data-prefix="fas"
            data-icon="language"
            role="img"
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 640 512"
            width="16"
            height="16"
        >
            <path
                fill="currentColor"
                d="M448 164C459 164 468 172.1 468 184V188H528C539 188 548 196.1 548 208C548 219 539 228 528 228H526L524.4 232.5C515.5 256.1 501.9 279.1 484.7 297.9C485.6 298.4 486.5 298.1 487.4 299.5L506.3 310.8C515.8 316.5 518.8 328.8 513.1 338.3C507.5 347.8 495.2 350.8 485.7 345.1L466.8 333.8C462.4 331.1 457.1 328.3 453.7 325.3C443.2 332.8 431.8 339.3 419.8 344.7L416.1 346.3C406 350.8 394.2 346.2 389.7 336.1C385.2 326 389.8 314.2 399.9 309.7L403.5 308.1C409.9 305.2 416.1 301.1 422 298.3L409.9 286.1C402 278.3 402 265.7 409.9 257.9C417.7 250 430.3 250 438.1 257.9L452.7 272.4L453.3 272.1C465.7 259.9 475.8 244.7 483.1 227.1H376C364.1 227.1 356 219 356 207.1C356 196.1 364.1 187.1 376 187.1H428V183.1C428 172.1 436.1 163.1 448 163.1L448 164zM160 233.2L179 276H140.1L160 233.2zM0 128C0 92.65 28.65 64 64 64H576C611.3 64 640 92.65 640 128V384C640 419.3 611.3 448 576 448H64C28.65 448 0 419.3 0 384V128zM320 384H576V128H320V384zM178.3 175.9C175.1 168.7 167.9 164 160 164C152.1 164 144.9 168.7 141.7 175.9L77.72 319.9C73.24 329.1 77.78 341.8 87.88 346.3C97.97 350.8 109.8 346.2 114.3 336.1L123.2 315.1H196.8L205.7 336.1C210.2 346.2 222 350.8 232.1 346.3C242.2 341.8 246.8 329.1 242.3 319.9L178.3 175.9z"
            />
        </svg>
    );

    return (
        <DropdownButton
            title={
                <span>
                    {selectedLanguage ? selectedLanguage?.attributes?.name : ""}{" "}
                    <LanguageIcon />
                </span>
            }
            className="position-absolute top-0 end-0 m-8 languague-dropdown hide-arrow"
        >
            {languages.filter(language => language?.attributes?.status == true)?.map((language, index) => (
                <Dropdown.Item
                    key={index}
                    onClick={() => handleLanguage(language)}
                    active={
                        selectedLanguage?.attributes?.iso_code ===
                        language?.attributes?.iso_code
                    }
                >
                    {language.attributes.name}
                </Dropdown.Item>
            ))}
        </DropdownButton>
    );
};

export default LanguageLayout;
