import React from "react";
import { Permissions } from "../constants";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
    faPieChart,
    faUser,
    faTruck,
    faUserGroup,
    faHome,
    faBoxes,
    faPrint,
    faBookmark,
    faBoxOpen,
    faMoneyCheckDollar,
    faMoneyBills,
    faQuoteRight,
    faDollarSign,
    faReceipt,
    faArrowRight,
    faArrowLeft,
    faEnvelope,
    faCartShopping,
    faChartColumn,
    faGear,
    faMapLocation,
    faBasketShopping,
    faSms,
    faCube,
    faFile,
    faRulerHorizontal,
    faLanguage,
    faShieldHalved,
    faLayerGroup,
    faMoneyBill,
    faTableColumns,
    faMoneyBill1Wave,
    faCircleQuestion,
    faStore,
    faMoneyCheck,
    faDisplay,
} from "@fortawesome/free-solid-svg-icons";
import { getFormattedMessage } from "../shared/sharedMethod";

export const userMenu = [
    {
        title: "dashboard.title",
        name: "dashboard",
        fontIcon: <FontAwesomeIcon icon={faPieChart} />,
        to: "/user/dashboard",
        class: "d-flex",
        permission: Permissions.MANAGE_DASHBOARD,
        items: [
            {
                title: getFormattedMessage("dashboard.title"),
                to: "/user/dashboard",
            },
        ],
    },
    {
        title: "products.title",
        name: "products",
        fontIcon: <FontAwesomeIcon icon={faBoxes} />,
        to: "/user/products",
        class: "d-flex",
        is_submenu: "true",
        permission: Permissions.MANAGE_PRODUCTS,
        subPath: {
            productsSubPath: "/user/products",
            categoriesSubPath: "/user/product-categories",
            variationsSubPath: "/user/variations",
            brandsSubPath: "/user/brands",
            unitsSubPath: "/user/units",
            baseUnitsSubPath: "/user/base-units",
            barcodeSubPath: "/user/print/barcode",
        },
        subMenu: [
            {
                title: "products.title",
                to: "/user/products",
                name: "products",
                class: "d-flex",
                fontIcon: <FontAwesomeIcon icon={faBoxes} />,
                permission: Permissions.MANAGE_PRODUCTS,
            },
            {
                title: "product.categories.title",
                name: "product categories",
                fontIcon: <FontAwesomeIcon icon={faBoxOpen} />,
                to: "/user/product-categories",
                class: "d-flex",
                permission: Permissions.MANAGE_PRODUCT_CATEGORIES,
            },
            {
                title: "variations.title",
                name: "variations",
                fontIcon: <FontAwesomeIcon icon={faLayerGroup} />,
                to: "/user/variations",
                class: "d-flex",
                permission: Permissions.MANAGE_VARIATIONS,
            },

            {
                title: "brands.title",
                name: "brands",
                fontIcon: <FontAwesomeIcon icon={faBookmark} />,
                to: "/user/brands",
                path: "/user/create-brand",
                class: "d-flex",
                permission: Permissions.MANAGE_BRANDS,
            },
            {
                title: "units.title",
                name: "units",
                fontIcon: <FontAwesomeIcon icon={faQuoteRight} />,
                to: "/user/units",
                class: "d-flex",
                permission: Permissions.MANAGE_UNITS,
            },
            {
                title: "base-units.title",
                name: "base units",
                fontIcon: <FontAwesomeIcon icon={faRulerHorizontal} />,
                to: "/user/base-units",
                class: "d-flex",
                permission: Permissions.MANAGE_UNITS,
            },
            {
                title: "print.barcode.title",
                name: "print barcode",
                fontIcon: <FontAwesomeIcon icon={faPrint} />,
                to: "/user/print/barcode",
                class: "d-flex",
                permission: Permissions.MANAGE_PRODUCTS,
            },
        ],
    },
    {
        title: "adjustments.title",
        name: "adjustments",
        fontIcon: <FontAwesomeIcon icon={faMapLocation} />,
        to: "/user/adjustments",
        class: "d-flex",
        permission: Permissions.MANAGE_ADJUSTMENTS,
        items: [
            {
                title: getFormattedMessage("adjustments.title"),
                to: "/user/adjustments",
            },
        ],
    },
    {
        title: "quotations.title",
        name: "quotations.title",
        fontIcon: <FontAwesomeIcon icon={faBasketShopping} />,
        to: "/user/quotations",
        class: "d-flex",
        permission: Permissions.MANAGE_QUOTATION,
        items: [
            {
                title: getFormattedMessage("quotations.title"),
                to: "/user/quotations",
            },
        ],
    },
    {
        title: "purchases.title",
        name: "purchases",
        fontIcon: <FontAwesomeIcon icon={faReceipt} />,
        to: "/user/purchases",
        class: "d-flex",
        is_submenu: "true",
        permission: Permissions.MANAGE_PURCHASE,
        subPath: {
            purchasesSubPath: "/user/purchases",
            purchaseReturnSubPath: "/user/purchase-return",
        },
        subMenu: [
            {
                title: "purchases.title",
                name: "purchases",
                fontIcon: <FontAwesomeIcon icon={faReceipt} />,
                to: "/user/purchases",
                class: "d-flex",
                permission: Permissions.MANAGE_PURCHASE,
            },
            {
                title: "purchases.return.title",
                name: "purchases return",
                fontIcon: <FontAwesomeIcon icon={faArrowLeft} />,
                to: "/user/purchase-return",
                class: "d-flex",
                permission: Permissions.MANAGE_PURCHASE_RETURN,
            },
        ],
    },
    {
        title: "sales.title",
        name: "sales",
        fontIcon: <FontAwesomeIcon icon={faCartShopping} />,
        to: "/user/sales",
        class: "d-flex",
        is_submenu: "true",
        permission: Permissions.MANAGE_SALE,
        subPath: {
            salesSubPath: "/user/sales",
            salesReturnSubPath: "/user/sale-return",
        },
        subMenu: [
            {
                title: "sales.title",
                name: "sales",
                fontIcon: <FontAwesomeIcon icon={faCartShopping} />,
                to: "/user/sales",
                class: "d-flex",
                permission: Permissions.MANAGE_SALE,
            },
            {
                title: "sales-return.title",
                name: "sales return",
                fontIcon: <FontAwesomeIcon icon={faArrowRight} />,
                to: "/user/sale-return",
                class: "d-flex",
                permission: Permissions.MANAGE_SALE_RETURN,
            },
        ],
    },
    {
        title: "transfers.title",
        name: "transfers",
        fontIcon: <FontAwesomeIcon icon={faMapLocation} />,
        to: "/user/transfers",
        class: "d-flex",
        permission: Permissions.MANAGE_TRANSFERS,
        items: [
            {
                title: getFormattedMessage("transfers.title"),
                to: "/user/transfers",
            },
        ],
    },
    {
        title: "expenses.title",
        name: "expenses",
        fontIcon: <FontAwesomeIcon icon={faMoneyBills} />,
        to: "/user/expenses",
        class: "d-flex",
        is_submenu: "true",
        permission: Permissions.MANAGE_EXPENSES,
        subPath: {
            expensesSubPath: "/user/expenses",
            expenseCategoriesSubPath: "/user/expense-categories",
        },
        subMenu: [
            {
                title: "expenses.title",
                name: "expenses",
                fontIcon: <FontAwesomeIcon icon={faMoneyBills} />,
                to: "/user/expenses",
                class: "d-flex",
                permission: Permissions.MANAGE_EXPENSES,
            },
            {
                title: "expense.categories.title",
                name: "expense categories",
                fontIcon: <FontAwesomeIcon icon={faMoneyCheckDollar} />,
                class: "d-flex",
                permission: Permissions.MANAGE_EXPENSES_CATEGORIES,
                to: "/user/expense-categories",
            },
        ],
    },
    {
        title: "pepole.title",
        name: "Pepoles",
        fontIcon: <FontAwesomeIcon icon={faUser} />,
        to: "/user/suppliers",
        class: "d-flex",
        is_submenu: "true",
        subPath: {
            customerSubPath: "/user/customers",
            userSubPath: "/user/users",
            suppliareSubPath: "/user/suppliers",
        },
        permission:
            Permissions.MANAGE_SUPPLIERS ||
            Permissions.MANAGE_CUSTOMERS ||
            Permissions.MANAGE_USER,
        subMenu: [
            {
                title: "suppliers.title",
                name: "suppliers",
                fontIcon: <FontAwesomeIcon icon={faTruck} />,
                to: "/user/suppliers",
                class: "d-flex",
                permission: Permissions.MANAGE_SUPPLIERS,
            },
            {
                title: "customers.title",
                name: "customers",
                fontIcon: <FontAwesomeIcon icon={faUserGroup} />,
                to: "/user/customers",
                class: "d-flex",
                permission: Permissions.MANAGE_CUSTOMERS,
            },
            {
                title: "users.title",
                name: "users",
                fontIcon: <FontAwesomeIcon icon={faUser} />,
                to: "/user/users",
                class: "d-flex",
                permission: Permissions.MANAGE_USER,
            },
        ],
    },
    {
        title: "roles.permissions.title",
        name: "roles",
        fontIcon: <FontAwesomeIcon icon={faShieldHalved} />,
        to: "/user/roles",
        class: "d-flex",
        permission: Permissions.MANAGE_ROLES,
        items: [
            {
                title: getFormattedMessage("roles.title"),
                to: "/user/roles",
            },
        ],
    },
    {
        title: "warehouse.title",
        name: "warehouse",
        fontIcon: <FontAwesomeIcon icon={faHome} />,
        to: "/user/warehouses",
        class: "d-flex",
        permission: Permissions.MANAGE_WAREHOUSES,
        items: [
            {
                title: getFormattedMessage("warehouse.title"),
                to: "/user/warehouse",
            },
        ],
    },
    {
        title: "reports.title",
        name: "reports",
        fontIcon: <FontAwesomeIcon icon={faChartColumn} />,
        to: "/user/report/report-warehouse",
        path: "/user/report/report-sale",
        stockPath: "/user/report/report-stock",
        purchasePath: "/user/report/report-purchase",
        topSellingPath: "/user/report/report-top-selling-products",
        stockDetailPath: "/user/report/report-detail-stock",
        productQuantityAlertPath: "/user/report/report-product-quantity",
        supplierReportPath: "/user/report/suppliers",
        profitLossReportPath: "/user/report/profit-loss",
        supplierReportDetailsPath: "/user/report/suppliers/details",
        bestCustomerReportPath: "/user/report/best-customers",
        customerReportPath: "/user/report/customers",
        customerReportDetailsPath: "/user/report/customers/details",
        registerReportPath: "/user/report/register",
        class: "d-flex",
        isSamePrefix: "true",
        permission: Permissions.MANAGE_REPORTS,
        subTitles: [
            { title: "warehouse.reports.title" },
            { title: "sale.reports.title" },
            { title: "stock.reports.title" },
            { title: "purchase.reports.title" },
            { title: "top-selling-product.reports.title" },
            { title: "product.quantity.alert.reports.title" },
            { title: "supplier.report.title" },
            { title: "best-customer.report.title" },
            { title: "customer.report.title" },
            { title: "customer.report.title" },
            { title: "profit-loss.reports.title" },
            { title: "best-customer.report.title" },
            { title: "register.report.title" },
        ],
        items: [
            {
                title: getFormattedMessage("warehouse.reports.title"),
                to: "/user/report/report-warehouse",
            },
            {
                title: getFormattedMessage("sale.reports.title"),
                to: "/user/report/report-sale",
            },
            {
                title: getFormattedMessage("stock.reports.title"),
                to: "/user/report/report-stock",
                detail: "/user/report/report-detail-stock",
            },
            {
                title: getFormattedMessage("purchase.reports.title"),
                to: "/user/report/report-purchase",
            },
            {
                title: getFormattedMessage("top-selling-product.reports.title"),
                to: "/user/report/report-top-selling-products",
            },
            {
                title: getFormattedMessage(
                    "product.quantity.alert.reports.title"
                ),
                to: "/user/report/report-product-quantity",
            },
            {
                title: getFormattedMessage("supplier.report.title"),
                to: "/user/report/suppliers",
                detail: "/user/report/suppliers/details",
            },
            {
                title: getFormattedMessage("profit-loss.reports.title"),
                to: "/user/report/profit-loss",
            },
            {
                title: getFormattedMessage("best-customer.report.title"),
                to: "/user/report/best-customers",
            },
            {
                title: getFormattedMessage("customer.report.title"),
                to: "/user/report/customers",
                detail: "/user/report/customers/details",
            },
            {
                title: getFormattedMessage("register.report.title"),
                to: "/user/report/register",
            },
        ],
    },
    {
        title: "template.title",
        name: "template",
        fontIcon: <FontAwesomeIcon icon={faFile} />,
        to: "/user/email-templates",
        class: "d-flex",
        is_submenu: "true",
        permission: Permissions.MANAGE_EMAIL_TEMPLATES,
        subPath: {
            emailTemplateSubPath: "/user/email-templates",
            smsTemplateSubPath: "/user/sms-templates",
            smsApiSubPath: "/user/sms-api",
        },
        subMenu: [
            {
                title: "email-template.title",
                name: "email-templates",
                fontIcon: <FontAwesomeIcon icon={faEnvelope} />,
                to: "/user/email-templates",
                class: "d-flex",
                permission: Permissions.MANAGE_EMAIL_TEMPLATES,
            },
            {
                title: "sms-template.title",
                name: "sms-templates",
                fontIcon: <FontAwesomeIcon icon={faSms} />,
                to: "/user/sms-templates",
                class: "d-flex",
                permission: Permissions.MANAGE_SMS_TEMPLATES,
            },
            {
                title: "sms-api.title",
                name: "sms-api",
                fontIcon: <FontAwesomeIcon icon={faCube} />,
                to: "/user/sms-api",
                class: "d-flex",
                permission: Permissions.MANAGE_SMS_API,
            },
        ],
    },
    {
        to: "/user/pos",
        class: "d-none",
        name: "pos",
        title: "header.pos.title",
        permission: Permissions.MANAGE_POS_SCREEN,
    },
    {
        title: "settings.title",
        name: "settings",
        fontIcon: <FontAwesomeIcon icon={faGear} />,
        to: "/user/settings",
        prefixesPath: "/user/prefixes",
        receiptSettingsPath: "/user/receipt-settings",
        taxesPath: "/user/taxes",
        posSettingsPath: "/user/pos-settings",
        class: "d-flex",
        isSamePrefix: "true",
        permission: Permissions.MANAGE_SETTING,
        subTitles: [
            { title: "prefix.title" },
            { title: "receipt-settings.title" },
            { title: "taxes.title" },
            { title: "pos.settings.title" },
        ],
        items: [
            {
                title: getFormattedMessage("settings.title"),
                to: "/user/settings",
            },
            {
                title: getFormattedMessage("prefix.title"),
                to: "/user/prefixes",
            },
            {
                title: getFormattedMessage("receipt-settings.title"),
                to: "/user/receipt-settings",
            },
            {
                title: getFormattedMessage("taxes.title"),
                to: "/user/taxes",
            },
            {
                title: getFormattedMessage("pos.settings.title"),
                to: "/user/pos-settings",
            },
        ],
    },
    {
        title: "store.title",
        name: "store",
        fontIcon: <FontAwesomeIcon icon={faStore} />,
        to: "/user/store",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("store.title"),
                to: "/user/store",
            },
        ],
    },
    {
        title: "payment.methods.title",
        name: "payment-methods",
        fontIcon: <FontAwesomeIcon icon={faMoneyCheck} />,
        to: "/user/payment-methods",
        class: "d-flex",
        permission: '',
        items: [
            {
                title: getFormattedMessage("payment.methods.title"),
                to: "/user/payment-methods",
            },
        ],
    },
    {
        title: "dual.screen.settings.title",
        name: "store",
        fontIcon: <FontAwesomeIcon icon={faDisplay} />,
        to: "/user/dual-screen-settings",
        class: "d-flex",
        permission: Permissions.MANAGE_POS_SCREEN,
        items: [
            {
                title: getFormattedMessage("dual.screen.settings.title"),
                to: "/user/dual-screen-settings",
            },
        ],
    },

];

export const adminMenu = [
    {
        title: "dashboard.title",
        name: "dashboard",
        fontIcon: <FontAwesomeIcon icon={faPieChart} />,
        to: "/admin/dashboard",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("dashboard.title"),
                to: "/admin/dashboard",
            },
        ],
    },
    {
        title: "users.title",
        name: "users",
        fontIcon: <FontAwesomeIcon icon={faUser} />,
        to: "/admin/users",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("users.title"),
                to: "/admin/users",
            },
        ],
    },
    {
        title: "plans.title",
        name: "plans",
        fontIcon: <FontAwesomeIcon icon={faTableColumns} />,
        to: "/admin/plans",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("plans.title"),
                to: "/admin/plans",
            },
        ],
    },
    {
        title: "cash-payments.title",
        name: "Cash Payments",
        fontIcon: <FontAwesomeIcon icon={faMoneyBill} />,
        to: "/admin/cash-payments",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("cash-payments.title"),
                to: "/admin/cash-payments",
            },
        ],
    },
    {
        title: "subscriptions.title",
        name: "Subscriptions",
        fontIcon: <FontAwesomeIcon icon={faMoneyBills} />,
        to: "/admin/subscriptions",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("subscriptions.title"),
                to: "/admin/subscriptions",
            },
        ],
    },
    {
        title: "transactions.title",
        name: "Subscriptions",
        fontIcon: <FontAwesomeIcon icon={faMoneyBill1Wave} />,
        to: "/admin/transactions",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("transactions.title"),
                to: "/admin/transactions",
            },
        ],
    },
    {
        title: "currencies.title",
        name: "currencies",
        fontIcon: <FontAwesomeIcon icon={faDollarSign} />,
        to: "/admin/currencies",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("currencies.title"),
                to: "/admin/currencies",
            },
        ],
    },
    {
        title: "languages.title",
        name: "Languages",
        fontIcon: <FontAwesomeIcon icon={faLanguage} />,
        to: "/admin/languages",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("languages.title"),
                to: "/admin/languages",
            },
        ],
    },
    {
        title: "inquiries.title",
        name: "Inquiries",
        fontIcon: <FontAwesomeIcon icon={faCircleQuestion} />,
        to: "/admin/inquiries",
        class: "d-flex",
        permission: "",
        items: [
            {
                title: getFormattedMessage("inquiries.title"),
                to: "/admin/inquiries",
            },
        ],
    },
    {
        title: "front-cms.title",
        name: "Front CMS",
        fontIcon: <FontAwesomeIcon icon={faHome} />,
        to: "/admin/front-cms/hero-section",
        path: "/admin/front-cms/services",
        partnersPath: "/admin/front-cms/partners",
        whyChoosUsPath: "/admin/front-cms/why-choose-us",
        testimonialsPath: "/admin/front-cms/testimonials",
        faqsPath: "/admin/front-cms/faqs",
        pagesPath: "/admin/front-cms/pages",
        termsPath: "/admin/front-cms/pages/terms-conditions",
        privacyPath: "/admin/front-cms/pages/privacy-policy",
        refundPath: "/admin/front-cms/pages/refund-policy",
        featurePath: "/admin/front-cms/features",
        stepPath: "/admin/front-cms/steps",
        class: "d-flex",
        isSamePrefix: "true",
        permission: "",
        subTitles: [
            { title: "front-cms.hero-section.title" },
            { title: "front-cms.services.title" },
            { title: "front-cms.partners.title" },
            { title: "front-cms.why.choose.us.title" },
            { title: "front-cms.testimonials.title" },
            { title: "front-cms.faqs.title" },
            { title: "features.title" },
            { title: "front.cms.step.title" },
            { title: "front-cms.pages.title" }
        ],
        items: [
            {
                title: getFormattedMessage("front-cms.hero-section.title"),
                to: "/admin/front-cms/hero-section",
            },
            {
                title: getFormattedMessage("front-cms.services.title"),
                to: "/admin/front-cms/services",
            },
            {
                title: getFormattedMessage("front-cms.partners.title"),
                to: "/admin/front-cms/partners",
            },
            {
                title: getFormattedMessage("front-cms.why.choose.us.title"),
                to: "/admin/front-cms/why-choose-us",
            },
            {
                title: getFormattedMessage("front-cms.faqs.title"),
                to: "/admin/front-cms/faqs",
            },
            {
                title: getFormattedMessage("front-cms.testimonials.title"),
                to: "/admin/front-cms/testimonials",
            },
            {
                title: getFormattedMessage("features.title"),
                to: "/admin/front-cms/features",
            },
            {
                title: getFormattedMessage("front.cms.step.title"),
                to: "/admin/front-cms/steps",
            },
            {
                title: getFormattedMessage("front-cms.pages.title"),
                to: "/admin/front-cms/pages/terms-conditions",
                privacyDetail: "/admin/front-cms/pages/privacy-policy",
                refundDetail: "/admin/front-cms/pages/refund-policy",
            },
        ],
    },
    {
        title: "settings.title",
        name: "settings",
        fontIcon: <FontAwesomeIcon icon={faGear} />,
        to: "/admin/settings",
        mailSettingsPath: "/admin/mail-settings",
        paymentSettingsPath: "/admin/payment-settings",
        class: "d-flex",
        isSamePrefix: "true",
        permission: "",
        isSingleActive: true,
        subTitles: [
            { title: "payment-settings.title" },
            { title: "mail-settings.title" },
        ],
        items: [
            {
                title: getFormattedMessage("settings.title"),
                to: "/admin/settings",
            },
        ],
    }
];
